/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.items.AbstractItemScroll;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScrollHighlight
extends AbstractItemScroll {
    public ItemScrollHighlight(Item.Properties properties) {
        super("scroll_highlight", properties);
    }

    @Override
    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K || ctx.func_195999_j() == null || !ctx.func_195999_j().func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        TileEntity te = ctx.func_195991_k().func_175625_s(ctx.func_195995_a());
        if (te instanceof TileEntityColonyBuilding) {
            ctx.func_195996_i().func_190918_g(1);
            if (ctx.func_195991_k().field_73012_v.nextInt(10) == 0) {
                ctx.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("minecolonies.scroll.failed" + (ctx.func_195991_k().field_73012_v.nextInt(10) + 1)).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
                ctx.func_195999_j().func_195064_c(new EffectInstance(Effects.field_188423_x, 6000));
                SoundUtils.playSoundForPlayer((ServerPlayerEntity)ctx.func_195999_j(), SoundEvents.field_187520_aJ, 0.3f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            TileEntityColonyBuilding building = (TileEntityColonyBuilding)te;
            List<ICitizenData> citizens = building.getColony().getBuildingManager().getBuilding(ctx.func_195995_a()).getAssignedCitizen();
            for (ICitizenData citizenData : citizens) {
                if (!citizenData.getEntity().isPresent()) continue;
                citizenData.getEntity().get().func_195064_c(new EffectInstance(Effects.field_188423_x, 2400));
                citizenData.getEntity().get().func_195064_c(new EffectInstance(Effects.field_76424_c, 2400));
            }
            SoundUtils.playSoundForPlayer((ServerPlayerEntity)ctx.func_195999_j(), SoundEvents.field_187802_ec, 0.3f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected boolean needsColony() {
        return false;
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, World world, ServerPlayerEntity player) {
        return itemStack;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        IFormattableTextComponent guiHint = LanguageHandler.buildChatComponent((String)"item.minecolonies.scroll_highlight.tip", (Object[])new Object[0]);
        guiHint.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)guiHint);
    }
}

